/*
    PROOF 1 nodes can have at maximum one node better than themselves
            PROOF BY CONTRADICTION:
                say we have node (l,a)-A1-A2-A3-(k,b) where A1,A2,A3 are the amount of coins in nodes 1,2,3 respectively
                and l is the amount of crystals needed to get all the left crystals to node 1, and a being the number of
                coins in that area, similiarly we have k and b for the right side of the tree. Now we assume tha
                A1+l+a+A3+k+b>l+2A1+2a+k+A2 and A1+l+a+A3+k+b>k+2A3+2b+l+A2 simplifying we get 
                b+A3>A1+a+A2 and A1+a>A3+b+A2 => b+A3+A1+a>A3+b+a+A1+2A2 => 0>2A2 (false since all the nodes have at least one coin)
    We now know that if we always follow the better node we will always get to the best result
    


*/
#include<bits/stdc++.h>
#define MAX_N 200000

using namespace std;

list<int> adj[MAX_N+1];
//long long tree[MAX_N*4];
int sparse[18][MAX_N*2];
int first[MAX_N];
int in[MAX_N];
int out[MAX_N];
int up[MAX_N][18];
long long fen[MAX_N+5]={};
int ts = 0;
int ti = 0;
int totalMoneyz=0;
vector<int> depth (MAX_N, -1);
//=======DFS FOR COMMON PREPROCES================
void dfs(int node,const int d){
    in[node] = ti++;

    first[node] = ts;
    sparse[0][ts++] = d;
    depth[node] = d;
    for(const auto& x : adj[node]){
        if(depth[x]<0) {
            dfs(x,d+1);
            up[x][0]=node;
            sparse[0][ts++]=d;
        }
    }
    out[node] = ti-1;
}
//=======FENWICK-TREE==========================

long long qfenwick(int l, int r){
    long long res = 0;
    l--;
    while (r >= 0){
        res += fen[r];
        r = (r & (r+1))-1;
    }
    while (l >= 0){
        res -= fen[l];
        l = (l & (l+1))-1;
    }
    return res;
}

void ufenwick(int r,int b, int n){
    for(;r < n ;r = r| (r+1))
        fen[r] += b;
}

void cfenwick(int* moneyz, int n){
    for(int i = 0;i<n;i++){
        ufenwick(i,moneyz[in[i]],n);
    }
}
//=======SPARSE-TABLE==========================
int log2_floor(unsigned long long i) {
    return i ? __builtin_clzll(1) - __builtin_clzll(i) : -1;
}

void cSparse(int n){
    for (int i = 1; i <= 17; i++)
        for (int j = 0; j + (1 << i) <= ts; j++)
            sparse[i][j] = min(sparse[i - 1][j], sparse[i - 1][j + (1 << (i - 1))]);
}

int qSparse(int l, int r){
    int i = log2_floor(r-l+1);
    return min(sparse[i][l], sparse[i][r - (1 << i) + 1]);
}
//============BINARY-LIFTING==================
void cBlift(int n){
    int LOG = log2_floor(n);

    up[0][0] = 0;
    for(int i = 0;i<n;i++){
        for(int j = 1; j<LOG+1;j++){
            up[i][j] = up[ up[i][j-1] ][j-1];
        }
    }

}
int qBlift(int node, int k,int n){
    int LOG = log2_floor(n);
    for(int i=0; i < LOG; i++){
        if(k&(1<<i)) {
            node = up[node][i];
        }
    }
    return node;
}


//================LCA=========================

int lca(int a, int b,int n){
    return qBlift(a,depth[a]-qSparse(min(first[a],first[b]),max(first[a],first[b])),n);
}
bool isAncestor(int a,int b){
    return in[a]<in[b] && out[b]<=out[a];
}

//===========FIND-GRADIENT=====================
int isLower(int a, int b){
    int s=1;
    if(isAncestor(b,a)){
        swap(a,b);
        s=0;
    }
        int mon = qfenwick(in[b],out[b]);
        if(mon>totalMoneyz-mon){
            return !s;
        }
        else if(mon == totalMoneyz-mon) return s==(a<b);
        else{
            return s;
        }
}

//INITIALPASS
int initial(int n){
    queue<int> a;
    a.push(0);
    int best = 0;
    while (!a.empty())
    {
        best = a.front();
        for(auto x: adj[best]){
            if(isLower(x,best)){a.push(x); continue;}
        }
        a.pop();
    }
    return best;
}

int update(int prev,int updated,int n){
    int tp = lca(prev,updated,n);
    int length = depth[prev]+depth[updated]-2*depth[tp];
    int l=0,r=length;
    int a =depth[prev]-depth[tp];
    int b =depth[updated]-depth[tp];

    while(l<r){
        int mid = (l+r)/2;
        int midnode = (mid<=a) ? qBlift(prev,mid,n):qBlift(updated,b-(mid-a),n);
        int midoff = (mid+1<=a) ? qBlift(prev,mid+1,n):qBlift(updated,b-(mid-a)-1,n);
        if(isLower(midoff,midnode)){
            l=mid+1;
        }
        else{
            r=mid;
        }
    }
    return (l<=a) ? qBlift(prev,l,n):qBlift(updated,(b-l-a),n);
}

int main(){
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);

    int n;
    cin >> n;

    int Moneyz[n];

    for(int i=0;i < n-1; i++){
        int x,y;
        cin >> x >> y;
        x--;
        y--;
        adj[x].push_back(y);
        adj[y].push_back(x);
    }
    dfs(0,0);
    for(int i=0;i < n; i++){
        cin >> Moneyz[in[i]];
        totalMoneyz+=Moneyz[in[i]];
    }
    cfenwick(Moneyz,n);
    cSparse(n);
    cBlift(n);
    int q;
    int best = initial(n);
    cout<<best+1<<endl;
    cin >> q;
    for(int i=0;i<q;i++){
        int a, b;
        cin >> a >> b;
        ufenwick(in[b-1],a,n);
        totalMoneyz+=a;
        best = update(best,b-1,n);
        cout<<best+1<<endl;
    }
        

    return 0;
}